#ifndef __ENEMY_AGENT__
#define __ENEMY_AGENT__
//#include "gamelib.h"
#include <ode/ode.h>
#include <stdbool.h>

#define ENEMY_AGENT_SPHERE_RADIUS 0.2
#define ENEMY_AGENT_MASS 1.0

#define ENEMY_AGENT_SIZE 2

struct EnemyAgentData{
  bool enabled;
  int hit_point;
  dBodyID body_ID;
  dGeomID geom_ID;
};

void initialize_enemy_agent();
void make_enemy_agent( int enemy_agent_index,
		       int initial_position_map_x,
		       int initial_position_map_y,
		       int initial_hit_point );
void visualize_enemy_agent( int enemy_agent_index );
void update_enemy_agent( int enemy_agent_index );
int get_enemy_agent_hit_point( int enemy_agent_index );
void destroy_enemy_agent( int enemy_agent_index );
bool enabled_enemy_agent( int enemy_agent_index );

#endif
