#ifndef __GAMELIB_MAP_H__
#define __GAMELIB_MAP_H__

#include "gamelib.h"
#include <ode/ode.h>
#include <drawstuff/drawstuff.h>

/*
The cordination of the most south west (left down) part is (0,0).
The first index increase from west to east.
The second index increase from south to north.
-----------------------
(0,2) | (1,2) | (2,2) |
(0,1) | (1,1) | (2,1) |
(0,0) | (1,0) | (2,0) |
-----------------------
*/
#define MAP_ONE_SQUIRE_MAX_WALL_SIZE 10
#define MAP_X_SIZE 3
#define MAP_Y_SIZE 3
#define MAP_SQUIRE_WIDTH 1.0

struct WallData{
  dGeomID geom_ID;
  dBodyID body_ID;
  dJointID fixed_joint_ID;
};

struct MapData{
  dReal center_position[2]; //[0]->x, [1]->y
  int wall_size;
  struct GameObject wall_object[MAP_ONE_SQUIRE_MAX_WALL_SIZE];
  struct WallData wall_data[MAP_ONE_SQUIRE_MAX_WALL_SIZE];
};

enum DIRECTION{
  /* for strait wall*/
  FROM_SOUTH_TO_NORTH,
  FROM_NORTH_TO_SOUTH,
  FROM_EAST_TO_WEST,
  FROM_WEST_TO_EAST,


  /* for turn wall*/
  FROM_SOUTH_TO_EAST,
  FROM_EAST_TO_SOUTH,

  FROM_EAST_TO_NORTH,
  FROM_NORTH_TO_EAST,

  FROM_NORTH_TO_WEST,
  FROM_WEST_TO_NORTH,

  FROM_WEST_TO_SOUTH,
  FROM_SOUTH_TO_WEST,

  /* for t junciton and dead end */
  FROM_SOUTH,
  FROM_EAST,
  FROM_NORTH,
  FROM_WEST,

};

#define WALL_HEIGHT 1.0
#define WALL_WIDTH 0.01
#define ROAD_WIDTH 0.9
#define WALL_MASS 1.0


void initialize_map();
void destroy_map();
int make_strait_walls( int map_x, int map_y, enum DIRECTION direction );
int make_turn_walls( int map_x, int map_y, enum DIRECTION direction );
int make_turn_left_walls( int map_x, int map_y, enum DIRECTION direction );
int make_t_junction_walls( int map_x, int map_y, enum DIRECTION direction );
int make_cross_road_walls( int map_x, int map_y);
int make_dead_end_walls( int map_x, int map_y, enum DIRECTION direction );
int make_wall( dReal wall_center_position_x, dReal wall_center_position_y,
	       dReal wall_direction_x, dReal wall_direction_y,
	       dReal wall_length,
	       struct GameObject* wall_object );

void rotate_90deg_clockwise( dReal* vec2 );
void rotate_90deg_anticlockwise( dReal* vec2 );
void rotate_180deg( dReal* vec2 );


void visualize_map();



#ifdef dDOUBLE
#define dsDrawBox dsDrawBoxD
#define dsDrawSphere dsDrawSphereD
#define dsDrawCylinder dsDrawCylinderD
#define dsDrawCapsule dsDrawCapsuleD
#endif

#endif
