#include <gamelib/enemy_agent.h>
#include <gamelib/map.h>
#include <gamelib/gamelib.h>
#include <gamelib/interaction.h>
#include <stdbool.h>

#define ITERS 20

int world_exist = false;
static dWorldID world_id;
static dSpaceID space_id;
static dJointGroupID contact_group_id;

static dGeomID ground_geom;
struct GameObject ground_object;


void initialize_gamelib(){
  if( world_exist ){
    dJointGroupDestroy( contact_group_id );
    dSpaceDestroy( space_id );
    dWorldDestroy( world_id );
  }
  world_id = dWorldCreate();
  
  //space_id = dHashSpaceCreate( 0 );
  //space_id = dSimpleSpaceCreate( 0 );
  space_id = dSweepAndPruneSpaceCreate( 0, dSAP_AXES_XYZ );
  
  contact_group_id = dJointGroupCreate (0);
  dWorldSetGravity( world_id, 0,0,-0.98);
  dWorldSetCFM( world_id, 1e-5);
  dWorldSetERP( world_id, 0.8);
  dWorldSetQuickStepNumIterations (world_id,ITERS);
  ground_geom = dCreatePlane (space_id,0,0,1,0);

  ground_object.object_type = GROUND;
  dGeomSetData( ground_geom, &ground_object );

  initialize_map();
  world_exist = true;
  dAllocateODEDataForThread(dAllocateMaskAll);
}

void update_gamelib(){
  dSpaceCollide(space_id, 0, &near_callback);
  //dWorldQuickStep(world_id,0.05);
  dWorldStep( world_id, SIMULATION_TIME_STEP);
  dJointGroupEmpty( contact_group_id );

}

void finalize_gamelib(){
  int enemy_agent_index;
  for( enemy_agent_index = 0; enemy_agent_index <ENEMY_AGENT_SIZE; enemy_agent_index++ ){
    if( true == enabled_enemy_agent( enemy_agent_index ) ){
      destroy_enemy_agent( enemy_agent_index );
    }
  }

  destroy_self_agent();
  destroy_map();
  dJointGroupDestroy( contact_group_id );
  dSpaceDestroy( space_id );
  dWorldDestroy( world_id );
  contact_group_id = NULL;
  space_id = NULL;
  world_id = NULL;
  world_exist = false;
  printf("finalize gamelib\n");
}

void near_callback (void *data, dGeomID geom1, dGeomID geom2)
{
  int contact_index,contact_number;
  dBodyID body1, body2;
  struct GameObject* game_object1;
  struct GameObject* game_object2;
  dJointID contact_joint_ID;
  const int max_contact_number = 10;
  dContact contact[ max_contact_number ];

  
  body1 = dGeomGetBody(geom1);
  body2 = dGeomGetBody(geom2);
  if(body1 && body2 && dAreConnected(body1, body2))return;
  game_object1 = ( struct GameObject* )dGeomGetData( geom1 );
  game_object2 = ( struct GameObject* )dGeomGetData( geom2 );
  
  /*
  if(dGeomGetClass(geom1) == dSphereClass ){
    printf("geom1 is dSphereClass\n");
  }else if(dGeomGetClass(geom1) == dBoxClass ){
    printf("geom1 is dBoxClass\n");
  }else if(dGeomGetClass(geom1) == dPlaneClass ){
    printf("geom1 is dPlaneClass\n");
  }
  if(dGeomGetClass(geom2) == dSphereClass ){
    printf("geom2 is dSphereClass\n");
  }else if(dGeomGetClass(geom2) == dBoxClass ){
    printf("geom2 is dBoxClass\n");
  }else if(dGeomGetClass(geom2) == dPlaneClass ){
    printf("geom2 is dPlaneClass\n");
  }
  printf("object1_type: %d, object2_type: %d\n",
	 (int)(game_object1->object_type),
	 (int)(game_object2->object_type));
  */
  
  if( WALL == game_object1->object_type && WALL == game_object2->object_type ){
    return;
  }else if( WALL == game_object1->object_type && GROUND == game_object2->object_type ){
    return;
  }else if( GROUND == game_object1->object_type && WALL == game_object2->object_type ){
    return;
  }else if( SELF_AGENT_BULLET == game_object1->object_type && SELF_AGENT_BULLET == game_object2->object_type ){
    return;
  }else if( SELF_AGENT == game_object1->object_type && SELF_AGENT_BULLET == game_object2->object_type ){
    return;
  }else if( SELF_AGENT_BULLET == game_object1->object_type && SELF_AGENT == game_object2->object_type ){
    return;
  }

  if( SELF_AGENT_BULLET == game_object1->object_type &&
      !dBodyIsEnabled( body1 ) ){
    return;
  }
  if( SELF_AGENT_BULLET == game_object2->object_type &&
      !dBodyIsEnabled( body2 ) ){
    return;
  }

  contact_number = dCollide( geom1, geom2, max_contact_number, &contact[0].geom, sizeof(dContact));
  if( 0 < contact_number ){
    if( SELF_AGENT_BULLET == game_object1->object_type && ENEMY_AGENT == game_object2->object_type ){
      self_agent_bullet_hits_to_enemy_agent( (struct SelfAgentBulletData*)( game_object1->data ),
                                             (struct EnemyAgentData*)( game_object2->data ) );
    }else if( SELF_AGENT_BULLET == game_object2->object_type && ENEMY_AGENT == game_object1->object_type ){
      self_agent_bullet_hits_to_enemy_agent( (struct SelfAgentBulletData*)( game_object2->data ),
                                             (struct EnemyAgentData*)( game_object1->data ) );
    }
    /* BEGIN Processing of contact between the self body and a enemy's body */
    else if( SELF_AGENT == game_object1->object_type && ENEMY_AGENT == game_object2->object_type ){
      contact_self_agent_and_enemy_agent( (struct EnemyAgentData*)( game_object2->data ) );
    }else if( SELF_AGENT == game_object2->object_type && ENEMY_AGENT == game_object1->object_type ){
      contact_self_agent_and_enemy_agent( (struct EnemyAgentData*)( game_object1->data ) );
    }
    /* END Processing of contact between the self body and a enemy's body */
  }
  for( contact_index = 0; contact_index < contact_number; ++contact_index ){
    contact[contact_index].surface.mode = dContactSlip1 | dContactSlip2 | dContactSoftERP | dContactSoftCFM | dContactApprox1;
    if (dGeomGetClass(geom1) == dSphereClass || dGeomGetClass(geom2) == dSphereClass){
      contact[contact_index].surface.mu = 20;
    }else{
      contact[contact_index].surface.mu = 0.5;
    }
    contact[contact_index].surface.slip1 = 0.0;
    contact[contact_index].surface.slip2 = 0.0;
    contact[contact_index].surface.soft_erp = 0.8;
    contact[contact_index].surface.soft_cfm = 0.01;
    contact_joint_ID = dJointCreateContact( world_id,contact_group_id,contact+contact_index);
    dJointAttach(contact_joint_ID, dGeomGetBody(geom1), dGeomGetBody(geom2));
  }
}


dWorldID get_ode_world_id(){
  return world_id;
}
dSpaceID get_ode_space_id(){
  return space_id;
}

dJointGroupID get_ode_contact_group_id(){
  return contact_group_id;
}

