#include "shooting_game.h"
#include <stdio.h>

enum VIEW_POINT_SWITCH{
  FIRST_PERSON_VIEW,
  BEHIND_VIEW,
};

enum VIEW_POINT_SWITCH view_point_switch = FIRST_PERSON_VIEW;

enum STAGE{
  FIRST_STAGE,
  SECOND_STAGE
};

enum STAGE stage;

void start(){
  initialize_gamelib();
  
  make_first_stage();
  stage = FIRST_STAGE;
#ifdef DEBUG_PRINT
  printf("start end\n");
#endif
}

void simLoop( int pause ){
  update_gamelib();
  
  update_self_agent();
  
  if( view_point_switch == BEHIND_VIEW ){
    /* Behind mode */
    set_behind_view_point();  
    visualize_self_agent();
  }else{
    /* First person view mode*/
    set_first_person_view_point();
  }
  visualize_self_agent_bullets();
  visualize_map();
  
  if( true == enabled_enemy_agent( 0 ) && 0 == get_enemy_agent_hit_point( 0 ) ){
    destroy_enemy_agent( 0 ); /* enabled_enemy_agent( 0 ) => false */
#ifdef DEBUG_PRINT
    printf("destroy_enemy_agent( 0 )\n");
#endif
  }
  if( true == enabled_enemy_agent( 1 ) && 0 == get_enemy_agent_hit_point( 1 ) ){
    destroy_enemy_agent( 1 ); /* enabled_enemy_agent( 1 ) => false */
#ifdef DEBUG_PRINT
    printf("destroy_enemy_agent( 1 )\n");
#endif
  }
  if( true == enabled_enemy_agent( 0 ) ){
    update_enemy_agent( 0 );
    visualize_enemy_agent( 0 );
  }
  if( true == enabled_enemy_agent( 1 ) ){
    update_enemy_agent( 1 );
    visualize_enemy_agent( 1 );
  }
  //printf("enamy 0 enabled flag: %d\n", enabled_enemy_agent( 0 ) );
  //printf("enamy 1 enabled flag: %d\n", enabled_enemy_agent( 1 ) );
  if( stage == FIRST_STAGE ){
    if( false == enabled_enemy_agent( 0 )  && false == enabled_enemy_agent( 1 ) ){
      printf("Congraturations! First stage clear!\n");
      finalize_gamelib();
      initialize_gamelib();
      make_second_stage();
      stage = SECOND_STAGE;
    }
  }if ( stage == SECOND_STAGE ){
    if( false == enabled_enemy_agent( 0 ) ){
      printf("Congraturations! Second stage clear!\n");
      finalize_gamelib();
      exit(0);
    }
  }
  if( get_self_agent_hit_point() <= 0 ){
    printf("You lose! Game Over!\n");
    stop();
    exit(0);
  }
  //printf("simLoop end\n");
}

void command( int c ){
  command_self_agent( c );

  if( c == 'v' ){
    if( view_point_switch == FIRST_PERSON_VIEW ){
      view_point_switch = BEHIND_VIEW;
    }else{
      view_point_switch = FIRST_PERSON_VIEW;
    }
  }
  if( c == 'u' ){
    if( true == enabled_enemy_agent( 1 ) ){
      destroy_enemy_agent( 1 );
    }else{
      make_enemy_agent(1, 0,2, 100);
    }
  }
  if( c == 'h' ){
    stop();
    exit(0);
  }
}
void stop(){
  finalize_gamelib();
}

void make_first_stage(){
  
  make_dead_end_walls(0,0, FROM_NORTH );
  make_t_junction_walls(0,1, FROM_EAST );
  make_dead_end_walls(0,2, FROM_SOUTH );
  make_turn_walls(1,0, FROM_EAST_TO_NORTH );
  make_cross_road_walls(1,1);
  make_turn_walls(1,2, FROM_SOUTH_TO_EAST );
  make_turn_walls(2,0, FROM_NORTH_TO_WEST );
  make_turn_walls(2,1,FROM_WEST_TO_SOUTH );
  make_dead_end_walls(2,2, FROM_WEST );
  
  
  initialize_self_agent( 0,0, 100,M_PI/2 );
  set_first_person_view_point();
  
  initialize_enemy_agent();
  
  make_enemy_agent( 0, /* Enemy agent index */
                    0, /* Initial position X */
                    1, /* Initial position Y */
                    10); /* Initial hit point*/
  make_enemy_agent(1, /* Enemy agent index */
                   0, /* Initial position X */
                   2, /* Initial position Y */
                   10); /* Initial hit point*/
  

}

void make_second_stage(){
 
  make_dead_end_walls( 2, 0, FROM_WEST);
  make_strait_walls  ( 1, 0, FROM_EAST_TO_WEST );
  make_turn_walls    ( 0, 0, FROM_EAST_TO_NORTH );
  make_strait_walls  ( 0, 1, FROM_NORTH_TO_SOUTH );
  make_turn_walls    ( 0, 2, FROM_SOUTH_TO_EAST );
  make_strait_walls  ( 1, 2, FROM_EAST_TO_WEST );
  make_turn_walls    ( 2, 2, FROM_WEST_TO_SOUTH );
  make_turn_walls    ( 2, 1, FROM_NORTH_TO_WEST );
  make_dead_end_walls( 1, 1, FROM_EAST );

  
  initialize_self_agent( 2, 0, 100, M_PI );
  set_first_person_view_point();
  
  initialize_enemy_agent();
  
  make_enemy_agent( 0, /* Enemy agent index */
		    1, /* Initial position X */
		    1, /* Initial position Y */
		    100); /* Initial hit point*/
#ifdef DEBUG_PRINT
  printf("second stage starts.\n");
#endif  
}
