#!/bin/sh

INSTALL_ROOT_DIRECTORY=`pwd`
ODE_INSTALL_DIR=$INSTALL_ROOT_DIRECTORY

# If intel compiler exist in the computer, icc and icpc should be applied to ODE.
CXX_COMPILER=g++
CC_COMPILER=gcc
LINKER=ld
AR=ar

# Version of Open Dynamics Engine
ODE_VERSION=0.13
# ODE directory
ODE_DIR=ode-${ODE_VERSION}

cd src
tar jxvf ode-${ODE_VERSION}.tar.bz2
cd ode-${ODE_VERSION}
./configure --enable-double-precision --with-trimesh=gimpact --enable-shared CXX=${CXX_COMPILER} CC=${CC_COMPILER} LD=${LINKER} AR=${AR} --prefix=${ODE_INSTALL_DIR} CXXFLAGS=-fPIC CCFLAGS=-fPIC
#./configure --enable-shared CXX=${CXX_COMPILER} CC=${CC_COMPILER} LD=${LINKER} AR=${AR} --prefix=$ODE_INSTALL_DIR CXXFLAGS=-fPIC CCFLAGS=-fPIC
#./configure --enable-shared --with-trimesh=gimpact CXX=${CXX_COMPILER} CC=${CC_COMPILER} LD=${LINKER} AR=${AR} --prefix=$ODE_INSTALL_DIR CXXFLAGS=-fPIC CCFLAGS=-fPIC
#./configure --enable-shared --with-trimesh=gimpact CXX=${CXX_COMPILER} CC=${CC_COMPILER} LD=${LINKER} AR=${AR} --prefix=$ODE_INSTALL_DIR CXXFLAGS=-fPIC CCFLAGS=-fPIC
make
make install
mkdir ../../include/drawstuff/
cp -r include/drawstuff/*.h ../../include/drawstuff/
cp drawstuff/src/.libs/libdrawstuff.* ../../lib/
cd ../gamelib/
make clean
make
make install
cd ../../application/shooting_game
make clean
make
make install

