#ifndef __SELF_AGENT__
#define __SELF_AGENT__
#include "gamelib.h"
#include <ode/ode.h>


#define SELF_AGENT_SPHERE_RADIUS 0.1
#define SELF_AGENT_MASS 1.0


#define PULLING_FORCE_SIZE 2.0
#define JUMPING_FORCE_SIZE 30.0
#define TURNING_STEP M_PI/18 /* [rad] = 10 [deg]*/

struct SelfAgentData{
  dBodyID body_ID;
  dGeomID geom_ID;
  int hit_point;
  dReal direction_angle; /* EAST direction is 0 [rad]*/
  dVector3 pulling_force;
};

struct SelfAgentBulletData{
  dBodyID body_ID;
  dGeomID geom_ID;
  int countdown_timer;
  /*
    the counter set arbitral value when the bullet is shot.
    the counter decrease.
    the bullet is disable from the simulation when the counter is zero.
  */
};

#define SELF_AGENT_BULLET_SPHERE_RADIUS 0.01
#define SELF_AGENT_BULLET_MASS 0.01
#define SELF_AGENT_BULLET_NUMBER 10

#define SELF_AGENT_BULLET_INITIAL_VELOCITY 1.0 /*[m/sec]*/
#define SELF_AGENT_BULLET_INITIAL_ANGLE 30/180.0*M_PI /*[rad]*/
#define SELF_AGENT_BULLET_SURVIVAL_TIME 3.0 /*[sec]*/

/*
   dReal initial_direction_angle
   EAST direction:        0 [rad] (  0[deg])
   NORTH direciton:  M_PI/2 [rad] ( 90[deg])
   WEST direciton:   M_PI   [rad] (180[deg])
   SOUTH direciton: -M_PI/2 [rad] (-90[deg])
*/
void initialize_self_agent( int map_x, int map_y,
		      int initial_hit_point,
		      dReal initial_direction_angle );
void update_self_agent();
void set_behind_view_point();
void set_first_person_view_point();
void command_self_agent( int command );
void self_agent_shoot_gun();
void visualize_self_agent();
void visualize_self_agent_bullets();
void destroy_self_agent();
const dReal* get_self_agent_position();
int get_self_agent_hit_point();
void change_self_agent_hit_point( int hit_point );

#endif


