#include <gamelib/map.h>
#include <gamelib/enemy_agent.h>
//#include <gamelib/self_agent.h>
#include <stdbool.h>
#include <assert.h>
//enum ObjectType enemy_agent_type = ENEMY_AGENT;

static struct GameObject enemy_agent[ENEMY_AGENT_SIZE];
static struct EnemyAgentData enemy_agent_data[ENEMY_AGENT_SIZE];

static bool enemy_agent_initialized = false;
static bool enemy_agent_enabled_flag[ENEMY_AGENT_SIZE];

void initialize_enemy_agent(){
  int enemy_agent_index;
  for( enemy_agent_index = 0; enemy_agent_index < ENEMY_AGENT_SIZE; enemy_agent_index++ ){
    enemy_agent_enabled_flag[ enemy_agent_index ] = false;
  }
  enemy_agent_initialized = true;
}

void make_enemy_agent( int enemy_agent_index,
                       int initial_position_map_x,
                       int initial_position_map_y,
                       int initial_hit_point ){
  dMass mass;
  int i;

  assert( enemy_agent_initialized == true );
  assert( enemy_agent_index < ENEMY_AGENT_SIZE );
  assert( enemy_agent_enabled_flag[enemy_agent_index] == false );
  /*
    if( enemy_agent_initialized == false ){
    assert("The enemy agent objects are not initialized.\n");
    return;
    }else if( ENEMY_AGENT_SIZE <= enemy_agent_index ){
    assert("The enemy agent index is exceeded beyond the limit.\n");
    return;
    }else if( enemy_agent_enabled_flag[enemy_agent_index] == true ){
    assert("The enemy agent has been already enalbed.\n");
    return;
    }
  */

  enemy_agent_data[enemy_agent_index].hit_point = initial_hit_point;

  enemy_agent_data[enemy_agent_index].body_ID = dBodyCreate( get_ode_world_id() );

  dBodySetPosition( enemy_agent_data[ enemy_agent_index ].body_ID,
  		    ( (dReal)initial_position_map_x + 0.5 ) * MAP_SQUIRE_WIDTH, /* x position */
  		    ( (dReal)initial_position_map_y + 0.5 ) * MAP_SQUIRE_WIDTH, /* y position */
  		    ENEMY_AGENT_SPHERE_RADIUS ); /* z position */

  dMassSetSphere( &mass, 1, ENEMY_AGENT_SPHERE_RADIUS );
  dMassAdjust( &mass, ENEMY_AGENT_MASS );
  dBodySetMass( enemy_agent_data[enemy_agent_index].body_ID, &mass );
  enemy_agent_data[ enemy_agent_index ].geom_ID = dCreateSphere( get_ode_space_id(), ENEMY_AGENT_SPHERE_RADIUS );
  dGeomSetBody( enemy_agent_data[enemy_agent_index].geom_ID, enemy_agent_data[ enemy_agent_index ].body_ID);

  enemy_agent[enemy_agent_index].object_type = ENEMY_AGENT;
  enemy_agent[enemy_agent_index].data = &(enemy_agent_data[enemy_agent_index]);
  dGeomSetData( enemy_agent_data[enemy_agent_index].geom_ID, &enemy_agent[enemy_agent_index] );

  enemy_agent_enabled_flag[ enemy_agent_index ] = true;
#ifdef DEBUG_PRINT
  printf("make_enemy_agent end\n");
#endif
}

void visualize_enemy_agent( int enemy_agent_index ){
  assert( enemy_agent_initialized == true );
  assert( enemy_agent_index < ENEMY_AGENT_SIZE );
  assert( enemy_agent_enabled_flag[enemy_agent_index] == true );

  dsSetTexture(DS_CHECKERED);
  dsSetColor(0.0,1.0,0.0);
  dsSetSphereQuality(2);
  dsDrawSphere (dGeomGetPosition( enemy_agent_data[enemy_agent_index].geom_ID ),
		dGeomGetRotation( enemy_agent_data[enemy_agent_index].geom_ID ),
		ENEMY_AGENT_SPHERE_RADIUS );
}

void update_enemy_agent( int enemy_agent_index ){
  assert( enemy_agent_initialized == true );
  assert( enemy_agent_index < ENEMY_AGENT_SIZE );
  assert( enemy_agent_enabled_flag[enemy_agent_index] == true );
  double Gain = 10;
  dVector3 force;
  force[0] = Gain*(drand48()-0.5);
  force[1] = Gain*(drand48()-0.5);
  force[2] = 0.0;//Gain*(drand48()-0.5);

  dBodyAddForce( enemy_agent_data[ enemy_agent_index ].body_ID,
                 force[0], force[1], force[2] );
  printf("enemy agent %d: %f %f %f\n", enemy_agent_index, force[0], force[1], force[2]);
}

int get_enemy_agent_hit_point( int enemy_agent_index ){
  assert( enemy_agent_initialized == true );
  assert( enemy_agent_index < ENEMY_AGENT_SIZE );
  assert( enemy_agent_enabled_flag[enemy_agent_index] == true );
  return enemy_agent_data[ enemy_agent_index ].hit_point;
}

void destroy_enemy_agent( int enemy_agent_index ){
  assert( enemy_agent_initialized == true );
  assert( enemy_agent_index < ENEMY_AGENT_SIZE );
  assert( enemy_agent_enabled_flag[enemy_agent_index] == true );

  dGeomSetData( enemy_agent_data[ enemy_agent_index ].geom_ID, NULL );
  dBodyDestroy( enemy_agent_data[ enemy_agent_index ].body_ID );
  dGeomDestroy( enemy_agent_data[ enemy_agent_index ].geom_ID );
  enemy_agent_enabled_flag[ enemy_agent_index ] = false;
}

bool enabled_enemy_agent( int enemy_agent_index ){
  assert( enemy_agent_initialized == true );
  assert( enemy_agent_index < ENEMY_AGENT_SIZE );

  return enemy_agent_enabled_flag[ enemy_agent_index ];
}
