#include <iostream>
#include <opencv2/opencv.hpp>

#define RATE 0.3

using namespace cv;

int main (int argc, char **argv){

	Mat src_img, dst_img;

	/* 摜ǂݍ */
	if(argc >= 2){
		src_img = imread(argv[1]);
	}else{
		printf(gPlease input path of image.\n");
		return -1;
	}

	if(!src_img.data){
		printf(gCannot find such image.\n");
		return -1;
	}

	/* 摜ROIi֐S̈jݒ */
	Rect roi(src_img.cols * (1-RATE)/2, src_img.rows * (1-RATE)/2, src_img.cols * RATE, src_img.rows * RATE);

	/* 摜ROI؂ */
	dst_img = src_img(roi);

	/* ROI摜ɕ` */
	rectangle(src_img, roi, Scalar(0, 255, 0), 2);

	/* ʂ\ */
	imshow("Source Image", src_img);
	imshow("Destination Image", dst_img);

	waitKey(0);
	
	return 1;
}
