#include <iostream>
#include <opencv2/opencv.hpp>

#define ANGLE -45.0
#define SCALE 0.5

using namespace cv;

int main (int argc, char **argv){
	
	Mat src_img, dst_img;

	/* 摜ǂݍ */
	if(argc >= 2){
		src_img = imread(argv[1]);
	}else{
		printf(gPlease input path of image.\n");
		return -1;
	}

	if(!src_img.data){
		printf(gCannot find such image.\n");
		return -1;
	}

	/*]S̐ݒ*/
	Point2f center = Point2f(src_img.cols / 2, src_img.rows / 2);

	/*AtBs̐*/
	Mat affine = getRotationMatrix2D(center, ANGLE, SCALE);

	/*摜̉]*/
	warpAffine(src_img, dst_img, affine, src_img.size(), INTER_CUBIC);

	/* ʂ\ */
	imshow("Source Image", src_img);
	imshow("Destination Image", dst_img);

	waitKey(0);
	
	return 1;
}
