#include <iostream>
#include <opencv2/opencv.hpp>

#define RRATE 0.6
#define GRATE 1.0
#define BRATE 0.0

using namespace cv;

int main (int argc, char **argv){

	int x, y;
	uchar p[3];
	Mat src_img, dst_img;

	/* 摜ǂݍ */
	if(argc >= 2){
		src_img = imread(argv[1]);
	}else{
		printf("Please input path of image.\n");
		return -1;
	}

	if(!src_img.data){
		printf("Cannot find such file.\n");
		return -1;
	}

	/* 摜Rs[ */
	src_img.copyTo(dst_img);

	/* flɃANZXA萔{ */
	for(y = 0; y < dst_img.rows; y++){
		for(x = 0; x < dst_img.cols; x++){
			p[0] = dst_img.data[y * dst_img.step + x * 3]; /* Blue */
			p[1] = dst_img.data[y * dst_img.step + x * 3 + 1]; /* Green */
			p[2] = dst_img.data[y * dst_img.step + x * 3 + 2]; /* Red */
			dst_img.data[y * dst_img.step + x * 3] = round(p[0] * BRATE);
			dst_img.data[y * dst_img.step + x * 3 + 1] = round(p[1] * GRATE);
			dst_img.data[y * dst_img.step + x * 3 + 2] = round(p[2] * RRATE);
		}
	}

	/* ʂ\ */
	imshow("Source Image", src_img);
	imshow("Destination Image", dst_img);

	waitKey(0);
	
	return 0;
}
