#include <iostream>
#include <opencv2/opencv.hpp>

using namespace cv;

/* O[oϐ */
char str[64];

void on_mouse(int event, int x, int y, int flags, void* userdata);

int main (void){

	int key;

	Mat src_img(Size(800, 200), CV_8UC3, Scalar(255, 255, 255));
	Mat dst_img = src_img.clone();

	/* EBhE̐ */
	namedWindow("Window", 1);

	/* }EXR[obN */
	setMouseCallback("Window", on_mouse, (void *)&src_img);

	while(1){

		/* 摜Rs[ */
		src_img.copyTo(dst_img);

		/* ` */
		putText(dst_img, str, Point(10, 50), FONT_HERSHEY_DUPLEX, 1.0, Scalar(0, 0, 0));

		/* 摜\ */
		imshow("Window", dst_img);

		/* ESCꂽI */
		key = waitKey(50);
		if(key == 27) break;
	}
	
	return 0;
}

void on_mouse(int event, int x, int y, int flags, void *param){

	switch(event){
		case EVENT_MOUSEMOVE:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Mouse Move");
			break;
		case EVENT_LBUTTONDOWN:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Left Button Down");
			break;
		case EVENT_RBUTTONDOWN:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Right Button Down");
			break;
		case EVENT_MBUTTONDOWN:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Middle Button Down");
			break;
		case EVENT_LBUTTONUP:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Left Button Down");
			break;
		case EVENT_RBUTTONUP:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Right Button Click");
			break;
		case EVENT_MBUTTONUP:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Middle Buttono Click");
			break;
		case EVENT_LBUTTONDBLCLK:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Left Button Double Click");
			break;
		case EVENT_RBUTTONDBLCLK:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Right Button Double Click");
			break;
		case EVENT_MBUTTONDBLCLK:
			snprintf(str, 64, "(%d, %d) %s", x, y, "Middle Button Double Click");
			break;
	}

	if(flags & EVENT_FLAG_LBUTTON)
		strncat(str, " + LBUTTON", 64);
	if(flags & EVENT_FLAG_RBUTTON)
		strncat(str, " + RBUTTON", 64);
	if(flags & EVENT_FLAG_MBUTTON)
		strncat(str, " + MBUTTON", 64);
	if(flags & EVENT_FLAG_CTRLKEY)
		strncat(str, " + CTRLKEY", 64);
	if(flags & EVENT_FLAG_SHIFTKEY)
		strncat(str, " + SHIFTKEY", 64);
	if(flags & EVENT_FLAG_ALTKEY)
		strncat(str, " + ALTKEY", 64);

}
